#include <bits/stdc++.h>
using namespace std;

// Struktura za cuvanje podataka o jarbolu
struct Jarbol {
    int id;         // Originalni indeks
    long long x;
    long long h;
};

// Komparator za sortiranje po x koordinati
bool compareJarbol(const Jarbol &a, const Jarbol &b) {
    return a.x < b.x;
}

const long long INF = 2e18; // Dovoljno veliki broj

int main() {
    // Brzi I/O je neophodan za N=10^6
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    if (!(cin >> n)) return 0;

    vector<Jarbol> jarboli(n);
    
    // Ucitavanje x
    for(int i = 0; i < n; i++) {
        jarboli[i].id = i;
        cin >> jarboli[i].x;
    }
    // Ucitavanje h
    for(int i = 0; i < n; i++) {
        cin >> jarboli[i].h;
    }

    // 1. Sortiranje po poziciji x
    sort(jarboli.begin(), jarboli.end(), compareJarbol);

    // Niz za cuvanje konacnog rezultata, indeksiran originalnim ID-jem
    vector<long long> ans(n, INF);

    // 2. Trazenje najblize tacke sa LEVE strane (Monotoni stek)
    stack<int> s; // Cuvamo indekse u sortiranom nizu
    for(int i = 0; i < n; i++) {
        // Izbacujemo sve manje jarbole jer oni ne mogu biti resenje
        // ni za trenutni, ni za buduce jarbole (jer je trenutni i blizi i visi od njih)
        while(!s.empty() && jarboli[s.top()].h < jarboli[i].h) {
            s.pop();
        }

        if(!s.empty()) {
            // Pronasli smo kandidata levo
            int target = s.top();
            long long dx = jarboli[i].x - jarboli[target].x;
            long long dh = jarboli[target].h - jarboli[i].h;
            long long dist = dx - dh;
            
            // Azuriramo resenje za originalni indeks
            ans[jarboli[i].id] = min(ans[jarboli[i].id], dist);
        }
        
        // Dodajemo trenutni na stek
        s.push(i);
    }

    // 3. Trazenje najblize tacke sa DESNE strane (Monotoni stek, cistimo stek)
    while(!s.empty()) s.pop(); 

    for(int i = n - 1; i >= 0; i--) {
        while(!s.empty() && jarboli[s.top()].h < jarboli[i].h) {
            s.pop();
        }

        if(!s.empty()) {
            // Pronasli smo kandidata desno
            int target = s.top();
            long long dx = jarboli[target].x - jarboli[i].x;
            long long dh = jarboli[target].h - jarboli[i].h;
            long long dist = dx - dh;
            
            ans[jarboli[i].id] = min(ans[jarboli[i].id], dist);
        }
        
        s.push(i);
    }

    // 4. Ispis resenja
    for(int i = 0; i < n; i++) {
        if(ans[i] == INF) {
            cout << "-1\n";
        } else {
            cout << ans[i] << "\n";
        }
    }

    return 0;
}